#ifndef PROTECTION_H
#define PROTECTION_H

// <<< Use Configuration Wizard in Context Menu >>>
// <h> ]wO@ﶵ
	// <e> Overvoltage/Undervoltage protection (OVP/UVP)
	// <i> Note: Need to use Vbus voltage divider resistors
	// <i> (OVER) (CLEAR_OVER)                         (CLEAR_UNDER) (UNDER)
	// <i> ----|-----------|------------------------------|-------------|---->
		#define Vbus_Protect 0
			#if (Vbus_Protect == 1)
				// <o> Set V_BUS_CH <0=> CH0 <1=> CH1 <2=> CH2 <3=> CH3 <4=> CH4 <5=> CH5 <6=> CH6 <7=> CH7 
				#define V_BUS_CH 6
					
				// <o> Set Vbus rate parameter (unit : 0.001)
				// <i> VBUS_GAIN = (Vbus_avg / Input voltage)*1000
					#define VBUS_GAIN ((float) 18750 / 1000)    // 27916
					
				// <o> OVER_BUS_VOLT_VALUE parameter (unit : 0.1V)
					#define OVER_BUS_VOLT_VALUE (uint16)((float) 250 * 0.1 * (VBUS_GAIN)) // unit : V * Gain
					
				// <o> CLEAR_OVER_BUS_VOLT_VALUE parameter (unit : 0.1V)
					#define CLEAR_OVER_BUS_VOLT_VALUE (uint16)((float) 230 * 0.1 * VBUS_GAIN) // unit : V * Gain
					
				// <o> CLEAR_UNDER_BUS_VOLT_VALUE parameter (unit : 0.1V)
					#define CLEAR_UNDER_BUS_VOLT_VALUE (uint16)((float) 220 * 0.1 * VBUS_GAIN) // unit : V * Gain
					
				// <o> UNDER_BUS_VOLT_VALUE parameter (unit : 0.1V)
					#define UNDER_BUS_VOLT_VALUE (uint16)((float) 210 * 0.1 * VBUS_GAIN) // unit : V * Gain
					
				// <o> BUS_VOLT Debounce parameter (unit : 40ms)
					#define BUS_VOLT_Debounce 	50 
			#endif
		#endif
	// </e>

	// <e> Locked-rotor protection
		// <i> Description: Speed Iq Id feedback abnormal related
		#define FaultLock_Protect 1
		#if (FaultLock_Protect == 1)
			#define OverSpeed (long)((float) ((RATED_SPEED) *1.2)* 32767 / (BASE_RPM))
			#define UnderSpeed (long)((float) ((RATED_SPEED)*0.05) * 32767 / (BASE_RPM))			
			// <o> FaultLock Debounce parameter (unit : 40ms)
			#define FaultLock_Debounce 	25
		#endif
	// </e>
	
	// <e> Over temperature protection(OTP)
	// <i> Note: Need to use temperature sensor
	// <i> (OVER) (CLEAR_OVER)                         (CLEAR_UNDER) (UNDER)
	// <i> ----|-----------|------------------------------|-------------|---->
		#define Temperature_Protect 0
		#if (Temperature_Protect == 1)
		// <o> Set OTP_CH <0=> CH0 <1=> CH1 <2=> CH2 <3=> CH3 <4=> CH4 <5=> CH5 <6=> CH6 <7=> CH7 
			#define TEMPERATURE_CH 3
			
		// <o> OVER_TEMPERATURE parameter (unit : Val)
			#define OVER_TEMPERATURE_VALUE 900 // unit : DegC * Gain
			
		// <o> CLEAR_OVER_TEMPERATURE parameter (unit : Val)
			#define CLEAR_OVER_TEMPERATURE_VALUE 800 // unit : DegC * Gain
			
		// <o> Temperature Debounce parameter (unit : ms)
			#define TEMPERATURE_Debounce 50 // unit : mSec
		#endif
	// </e>
	
	// <h> Phase current protection
	// <i> Description : IaBIbBIc
		// #define POCP_Protect 0
		// #if (POCP_Protect == 1)
			// <o> Phase IaBIbBIc parameter (unit : mA)
				#define PHASE_OCP (float)2000/1000 
				#define PHASE_OCP_VALUE (int16)((float) PHASE_OCP * I_AMPLIFIER) // unit : A * Gain
				
			// <o> PHASE_OCP_DURATION parameter (unit : ms)
				#define PHASE_OCP_DURATION 50
		// #endif
	// </h>
	
	// <e> Lack of phase protection (LPP)
		#define LACK_OF_PHASE_Protect 0
		#if (LACK_OF_PHASE_Protect == 1)
			// <o> Setting Phase Current MAX
			// <i> [LPP_Observer_A/B/Cb̧Ct_@᪺۫,H[̰t_۪
			// <i> ̰t_۪  < Phase Current MAX < ̧Ct_@᪺۫
				#define dLACK_PHASE_MAX_CURRENT		700
		#endif
	// </e>
				
	// <h> ]wҿﶵ/

		// <e> AOCP_Retry_Enable
			#define AOCP_Retry_ENABLE			0
		// </e>
		
		// <e> POCP_Retry_Enable
			#define POCP_Retry_ENABLE			0
		// </e>
		
		// <e> FaultLock_Retry_Enable
			#define FaultLock_Retry_ENABLE		1
		// </e>
		
		// <e> OTP_Retry_Enable
			#define OTP_Retry_ENABLE			0
		// </e>
		
		// <e> LPP_Retry_Enable
			#define LPP_Retry_ENABLE			0
		// </e>
		
		// <o> Set Retry times <0-255>
			#define RETRY_COUNT 5
		// <o> Set Restart delay time(unit : ms) <0-65535>
			#define RESTART_DURATION 1000
	// </h>
// </h>	

// <h> Error code(MotorErrorState)
	// <i>	Clear =						0(L~)
	// <i>	OverVbus =					1(Lq)
	// <i>	UnderVbus =					2(q)
	// <i>	OverTemperature =			4(L)
	// <i>	FaultLock =					8()
	// <i>	AOCP =						16(Lqy)
	// <i>	POCP =						32(۹qy`)
	// <i>	LPP =					    64(ʬ)
// </h>
// <<< end of configuration section >>>

#if (Vbus_Protect == 1)
	extern void Vbus_Protect_Fun (uint16 Adc_Vbus);
#endif

#if (Temperature_Protect == 1)
	extern void Temperature_Protect_Fun (uint16 Adc_Temperature);
#endif

#if (FaultLock_Protect == 1)
	extern void FaultLock_Fun (void);
#endif

#if (LACK_OF_PHASE_Protect == 1)
	extern xdata uint16 Lack_Phase_Max_Current;
#endif

extern void AOCP_Protect_Fun (void);

// #if (POCP_Protect == 1)
	extern void Phase_OCP_Protect_Fun (void);

	extern xdata int16 	IaFb;
	extern xdata int16 	IbFb;
	extern xdata int16 	IcFb;
// #endif

	extern xdata int16		IA_ABS;
	extern xdata int16		IB_ABS;
	extern xdata int16		IC_ABS;
	extern xdata int16		IA_ABS_MAX;
	extern xdata int16		IB_ABS_MAX;
	extern xdata int16		IC_ABS_MAX;
	extern idata uint8		ProtectState;
extern void Protect_scan(void);
extern void MotorStartRetry_Flow (void);
extern void FaultLock_Fun (void);
extern void Vbus_Protect_Fun (uint16 Adc_Vbus);
#endif
